/**
 * @package   	JCE
 * @copyright 	Copyright (c) 2009-2018 Ryan Demmer. All rights reserved.
 * @license   	GNU/GPL 2 or later - http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * JCE is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */
//fake tinyMCE object for language files
var tinyMCE = {
    addI18n: function(p, o) {
        return jQuery.Plugin.addI18n(p, o);
    }
};

var Browser = {
    params: {
        "window": window.parent,
        "callback": function(selected, data) {
            var win = window.parent,
                options = BrowserDialog.settings,
                value = data[0].url;

            if (win.jQuery) {
                // Joomla 3.5.x Media Field
                var wrapper = win.jQuery('#' + options.element).parents('.field-media-wrapper').get(0);

                if (wrapper) {
                    var inst = win.jQuery(wrapper).data('fieldMedia');

                    if (inst) {
                        return inst.setValue(value);
                    }
                }

                win.jQuery('#' + options.element).val(value).change();
            } else {
                var el = win.document.getElementById(options.element.element);

                if (el) {
                    el.value = value;
                }
            }
        }
    },
    editor: {
        close: function() {
            var win = window.parent,
                options = BrowserDialog.settings;

            // JCE dialog
            if (typeof win.$jce !== 'undefined') {
                return win.$jce.closeDialog('#' + options.element + '_browser');
            }

            // Joomla 3.5.x Media Field
            if (options.element && typeof win.jQuery.fieldMedia !== 'undefined') {
                var wrapper = win.jQuery('#' + options.element).parents('.field-media-wrapper').get(0);

                var inst = win.jQuery(wrapper).data('fieldMedia');

                if (inst) {
                    return inst.modalClose();
                }
            }

            // jModalClose
            if (typeof win.jModalClose !== 'undefined') {
                return win.jModalClose();
            }

            // try squeezebox
            if (typeof win.SqueezeBox !== 'undefined') {
                return win.SqueezeBox.close();
            }
        }
    }
};

jQuery(document).ready(function($) {
    var win = window.parent,
        element = win.document.getElementById(BrowserDialog.settings.element);

    // Joomla 3.5.x Media Field
    if (element && element.className.indexOf(' field-media-input ') !== -1) {
        $('#cancel').hide();
    }
});